/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.init.ModBlocks;
import dev.toma.gunsrpg.integration.jei.JeiIntegration;
import dev.toma.gunsrpg.resource.MultiIngredient;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchRecipe;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AmmoBenchRecipeCategory
implements IRecipeCategory<AmmoBenchRecipe> {
    private static final ResourceLocation BACKGROUND_TEXTURE = GunsRPG.makeResource("textures/screen/jei_ammo_bench.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated progress;

    public AmmoBenchRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(BACKGROUND_TEXTURE, 0, 0, 162, 36).setTextureSize(188, 36).build();
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.AMMO_BENCH));
        this.progress = helper.drawableBuilder(BACKGROUND_TEXTURE, 162, 0, 26, 12).setTextureSize(188, 36).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return JeiIntegration.AMMO_BENCH;
    }

    public Class<? extends AmmoBenchRecipe> getRecipeClass() {
        return AmmoBenchRecipe.class;
    }

    public String getTitle() {
        return "Ammo Bench";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AmmoBenchRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs().stream().map(MultiIngredient::getItemStackList).collect(Collectors.toList()));
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputs().stream().map(AmmoBenchRecipe.AmmoBenchOutput::getItemStack).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, AmmoBenchRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 3; ++x) {
                int inputSlotIndex = y * 3 + x;
                int outputSlotIndex = inputSlotIndex + 6;
                if (inputSlotIndex < inputs.size()) {
                    group.init(inputSlotIndex, true, x * 18, y * 18);
                    group.set(inputSlotIndex, (List)inputs.get(inputSlotIndex));
                }
                if (inputSlotIndex >= outputs.size()) continue;
                group.init(outputSlotIndex, false, 108 + x * 18, y * 18);
                group.set(outputSlotIndex, (List)outputs.get(inputSlotIndex));
            }
        }
    }

    public void draw(AmmoBenchRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.progress.draw(matrixStack, 68, 12);
        String label = recipe.getCraftingTimer() / 20 + "s";
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_238421_b_(matrixStack, label, 81.0f - (float)font.func_78256_a(label) / 2.0f, 27.0f, 0x404040);
    }
}

